#ifndef MAIN_H
#define MAIN_H

#define Timer1ms 1
#define Timer5ms 5
#define Timer10ms 10

#define PeriodTime10ms 10
#define PeriodTime50ms 50
#define PeriodTime100ms 100
#define PeriodTime1000ms 1000

#define SDModeEnable 1
#define SDModeDisable 0

#define SDMode0 0x0
#define SDMode1 0x1
#define SDMode2 0x2
#define SDMode3 0x3

#define PLLDiv1 0x0<<2 // 48MHz
#define PLLDiv2 0x1<<2 // 24MHz
#define PLLDiv4 0x2<<2 // 12MHz
#define PLLDiv8 0x3<<2 // 6MHz

#define SET(reg,bit) (reg |= (1<<bit))
#define CLR(reg,bit) (reg &= ~(1<<bit))
#define SetBit(reg,bit,val) val?(reg |= (1<<bit)):(reg &= ~(1<<bit))
#define GetBit(reg,bit) (reg & (1<<bit))
#define SetReg(reg,val) (reg = val)
#define Q15(n) (int16)(n*32767.0)
	
typedef struct _MOTOR_COMPONENT{// the struct name is a suggestion
	uint16 a;
	uint16 b;
	uint16 c;
}MOTOR_COMPONENT,*PMOTOR_COMPONENT;// here are two types

// <<< Use Configuration Wizard in Context Menu >>>
	// <o> Set Power Init Delay Mechanical Cycle (unit:1/F_CPU)
	// <i> F_CPU = 24MHZ
		#define		dPOWER_ON_DELAY_Mechanical_Cycle			(10000)
// <<< end of configuration section >>>

extern 	bit 		IPD_AUTO_TEST_Flag;
extern 	bit			EEPROM_READ_FLAG;
extern 	bit 		Timer0Flag;
extern 	bit 		Timer1Flag;
extern 	bit 		PwmFlag;
extern 	idata		uint16	IPWM_RUN_TIME;
extern 	idata		uint16	IPWM_STOP_TIME;
extern 	uint8 		Timer0Count;
extern 	idata   	uint16 	IPDCount;
extern  xdata 		uint16 IrDA_CMD;
#endif
